﻿using Aplication.Database;
using System.Data.Odbc;
using System.IO;

namespace Aplication.Classes
{
    public class DatabaseFileHandler
    {
        private static readonly string DB_UPLOAD_FOLDER = Path.Combine(new string[] { "C:\\PostgreSQL" ,
            "12", "data"} );

        private static readonly string WORKING_DIRECTORY_PREFIX = Path.Combine(new string[] { "C:\\Users",
            "Kubis", "Desktop", "Bakalarska praca", "Aplikacia remake", "Aplication", "Users files"});
        
        public static string GetOrCreateWorkingDirectory(string username)
        {
            string path = Path.Combine(WORKING_DIRECTORY_PREFIX, username, "solutions");
            if (Directory.Exists(path))
                return path;
            else
            {
                try
                {
                    DirectoryInfo info = Directory.CreateDirectory(path);
                    return info.FullName.ToString();
                } catch (DirectoryNotFoundException e)
                {
                    string msg = e.Message;
                    return string.Empty;
                } catch(System.UnauthorizedAccessException e)
                {
                    string msg = e.Message;
                    return string.Empty;
                } catch (PathTooLongException e)
                {
                    string msg = e.Message;
                    return string.Empty;
                } catch (IOException e)
                {
                    string msg = e.Message;
                    return string.Empty;
                } catch (System.Exception e)
                {
                    string msg = e.Message;
                    return string.Empty;
                }
            }
        }

        public static string GetDownloadLocation()
        {
            return DB_UPLOAD_FOLDER;
        }   

        public static bool SaveFileToDatabse(string path)
        {
            string sql = "INSERT INTO lectures(page_object) SELECT pg_read_binary_file(?);";
            DBContext.Instance.Open();
            OdbcCommand command = DBContext.Instance.Connection.CreateCommand();
            command.CommandText = sql;
            command.Parameters.AddWithValue("binary_file", Path.GetFileName(path));
            try
            {
                int val = command.ExecuteNonQuery();
                if (val > 0)
                    System.Console.WriteLine("file saved into database sucessfully");
                else
                    throw new System.Exception("file was not saved in database");
                File.Delete(path);
                return true;

            } catch (OdbcException e)
            {
                System.Console.WriteLine(e.Message);
                return false;
            } catch (System.Exception e)
            {
                System.Console.WriteLine(e.Message);
                return false;
            }
        }

        public static string LoadFileFromDabase(string pathToSave)
        {
            if (File.Exists(path: pathToSave))
                File.Delete(pathToSave);

            string sql = "SELECT page_object FROM lectures ORDER BY id DESC LIMIT 1;";
            DBContext.Instance.Open();
            OdbcCommand command = DBContext.Instance.Connection.CreateCommand();
            command.CommandText = sql;
            try
            {
                byte[] bytes = (byte[]) command.ExecuteScalar();
                using (FileStream fs = new FileStream(path: pathToSave, mode: FileMode.Create))
                {
                    fs.Write(bytes, 0, bytes.Length);
                }
            }
            catch (IOException e) { System.Console.WriteLine(e.Message); pathToSave = null; }
            catch (OdbcException e) { System.Console.WriteLine(e.Message); pathToSave = null; }
            catch (System.InvalidCastException e) { System.Console.WriteLine(e.Message); pathToSave = null; }
            catch (System.NotSupportedException e) { System.Console.WriteLine(e.Message); pathToSave = null; }
            catch (System.Exception e) { System.Console.WriteLine(e.Message); pathToSave = null; }
            return pathToSave;
        }
    }
}