﻿using System.IO;
using System.Diagnostics;
using System.Text;


namespace Aplication.Classes
{
    public class SubProcess
    {
        private string TestPath { get; set; }
        public string Result { get; private set; }

        public static string RunExternalCode(string absolutePath)
        {
            StringBuilder builder = new StringBuilder(128);
            try
            {
                using (Process process = new Process())
                {
                    process.StartInfo = new ProcessStartInfo()
                    {
                        FileName = "python",
                        Arguments = "\"" + absolutePath + "\"",
                        UseShellExecute = false,
                        RedirectStandardOutput = true,
                        RedirectStandardError = true
                    };
                    process.Start();
                    process.WaitForExit(5000);

                    using (StreamReader output = process.StandardOutput)
                    {
                        string row = string.Empty;
                        while ((row = output.ReadLine()) != null)
                        {
                            builder.Append(row.ToString());
                            builder.Append(System.Environment.NewLine);
                        }
                    }
                    using (StreamReader output = process.StandardError)
                    {
                        string row = string.Empty;
                        while ((row = output.ReadLine()) != null)
                            builder.Append(row.ToString());
                    }
                }
            }

            catch (System.ComponentModel.Win32Exception e) { builder.Append(e.Message); }
            catch (System.InvalidOperationException e)     { builder.Append(e.Message); }
            catch (System.Exception e)                     { builder.Append(e.Message); }

            return builder.ToString();
        }

        private static void ClearSandbox(string sandboxiePath)
        {
            string args = "delete_sandbox";
            try
            {
                using (Process p = new Process())
                {
                    p.StartInfo = new ProcessStartInfo()
                    {
                        FileName = sandboxiePath.ToString(),
                        Arguments = args
                    };
                    p.Start();
                    p.WaitForExit(5_000);
                }
            }
            catch (System.ComponentModel.Win32Exception) { }
            catch (System.ObjectDisposedException) { }
            catch (System.InvalidOperationException) { }
            catch (System.Exception) { }
        }


        public static string Run(string username, string lessonName)
        {
            string result = string.Empty;
            string unittestFilePath = Path.Combine(new string[] { "C:\\Users", "Kubis", "Desktop", "Bakalarska praca",
                "Aplikacia remake", "Aplication", "Unit tests", lessonName, "test.py" });

            string solutionPath = Path.Combine(new string[] { "C:\\Users", "Kubis", "Desktop", "Bakalarska praca",
                "Aplikacia remake", "Aplication", "Users files", username, "solutions", "test.py" });

            string sandboxiePath = Path.Combine(new string[] { "C:\\Sandboxie", "Start.exe" });
            ClearSandbox(sandboxiePath);

            string resultPath = Path.Combine(new string[] { "C:\\Sandbox", "Kubis","DefaultBox", "user", "current", "Desktop",
                "Bakalarska praca", "Aplikacia remake", "Aplication", "Users files", username, "solutions", "output.txt"});

            try
            {
                if (!File.Exists(solutionPath))
                    File.Copy(unittestFilePath, solutionPath, false);
            }
            catch (FileNotFoundException) { }
            catch (PathTooLongException) { }
            catch (DirectoryNotFoundException) { }
            catch (IOException) { }

            
            try
            {
                using (Process process = new Process())
                {
                    ProcessStartInfo info = new ProcessStartInfo()
                    {
                        FileName = sandboxiePath,
                        UseShellExecute = false,
                        RedirectStandardOutput = true,
                        RedirectStandardError = true,
                        Arguments = "python \"" + solutionPath + "\""                        
                    };
                    process.StartInfo = info;
                    process.Start();
                    process.WaitForExit(30_000);

                    //THIS CONTROL CAN BE BAMBOOZLED ?!?! 
                    int elapsedSecs = 0;
                    while (!File.Exists(resultPath) && elapsedSecs < 30)
                    {
                        try
                        {
                            System.Threading.Thread.Sleep(1_000);
                            elapsedSecs++;
                        }
                        catch (System.ArgumentOutOfRangeException) { }
                        catch (System.Threading.ThreadInterruptedException) { }
                        catch (System.Threading.ThreadAbortException) { }
                        catch (System.Exception) { }
                    }

                    if (elapsedSecs > 30 && !process.HasExited)
                        return "timeout elapsed...";

                    using (StreamReader reader = new StreamReader(
                        new FileStream(resultPath, FileMode.Open)))
                    {
                        StringBuilder builder = new StringBuilder(128);
                        string line = string.Empty;
                        while ((line = reader.ReadLine()) != null)
                        {
                            builder.Append(line);
                            builder.Append(System.Environment.NewLine);
                            builder.Append("<br>");
                        }
                        result = builder.ToString();
                    }
                }
            }
            catch (IOException e) { result = e.Message; }
            catch (System.InvalidOperationException e) { result = e.Message; }
            catch (System.ComponentModel.WarningException e) { result = e.Message; }

            return result;
        }
        private SubProcess() {}
    }
}