﻿using System.Web.Mvc;
using Aplication.Models;

namespace Aplication.Controllers
{
    public class DashboardController : Controller
    {
        public ViewResult Index()
        {
            if (this.Session[UserModel.KEY_TO_SESSION] != null)
            {
                UserModel model = (UserModel)this.Session[UserModel.KEY_TO_SESSION];
                return new ViewResult()
                {
                    ViewName = @"~/Views/Dashboard/Index.cshtml",
                    ViewData = new ViewDataDictionary()
                    {
                        Model = model
                    }
                };
            }
            else
            {
                return new ViewResult()
                {
                    ViewName = @"~\Views\Home\Index.cshtml"
                };
            }
        }

        public ViewResult Show(string lesson, int pageIndex)
        {
            LessonModel model = null;
            if (LessonModel.LessonExists(lesson, pageIndex))
                model = LessonModel.LoadByLessonName(lesson, pageIndex);
            else
                model = new LessonModel() { LessonName = lesson };

            return new ViewResult
            {
                ViewName = @"~/Views/Dashboard/Show.cshtml",
                ViewData = new ViewDataDictionary()
                {
                    Model = model
                }
            };
        }

        public ViewResult EditLesson(string lesson)
        {
            LessonModel model = null;
            string key = LessonModel.KEY_TO_SESSION;
            if (Session[key] != null)
                model = (LessonModel)Session[key];
            else
                throw new System.Exception("LessonModel is not in session");

            return new ViewResult()
            {
                ViewName = @"~/Views/Dashboard/EditLesson.cshtml",
                ViewData = new ViewDataDictionary()
                {
                    Model = model
                }
            };
        }

        public ViewResult AddChapter()
        {
            LessonModel previous = (LessonModel)this.Session[LessonModel.KEY_TO_SESSION];
            return new ViewResult()
            {
                ViewName = @"~/Views/Dashboard/AddChapter.cshtml",
                ViewData = new ViewDataDictionary()
                {
                    Model = new LessonModel()
                    {
                        PageIndex = previous.PageIndex + 1,
                        LessonName = previous.LessonName,
                        VideoPath = previous.VideoPath
                    }
                }
            };
        }
    }
}