﻿using System.Web.Mvc;
using Aplication.Classes;
using Aplication.Database;
using System.IO;
using Aplication.Models;

namespace Aplication.Controllers
{
    public class TestController : Controller
    {
        public ContentResult Index(string lessonName)
        {
            ContentResult result = new ContentResult();
            if (string.IsNullOrEmpty(Session[UserModel.KEY_TO_SESSION].ToString()))
            {
                result.Content = "Test controller / index received empty username";
                return result;
            }

            string username = Session[UserModel.KEY_TO_SESSION].ToString();

            string path = DatabaseFileHandler.GetOrCreateWorkingDirectory(username);
            path += "\\solution.py";
            
            //here must be constring to download file that belongs to this user - send username
            path = DatabaseFileHandler.LoadFileFromDabase(path);

            result = RunTest(username, lessonName);
            return result;
        }

        private ContentResult RunTest(string username, string lessonName)
        {
            string output = "could not load results";

            output = SubProcess.Run(username: username, lessonName: lessonName);
            ContentResult content = new ContentResult
            {
                Content = output,
            };
            return content;
        }
    }
}