﻿using System.IO;
using System.Text;

namespace Aplication.Models
{
    /// <summary>
    /// <para>
    ///     string pathToFile: full path to the original file with extension (*.py)
    ///     string pathToTmpFolder: full path to the folder / directory where tmp.py will be saved
    /// </para>
    /// </summary>
    public class CodeModel
    {
        public string PathToFile            { get; set; }
        public string PathToTmp             { get; set; }
        public string OriginalFileContent   { get; set; }

        public CodeModel(string pathToFile, string pathToTmpFolder)
        {
            PathToFile = pathToFile;
            PathToTmp = Path.Combine(pathToTmpFolder, "tmp.py");

            try
            {
                StringBuilder builder = new StringBuilder(16);
                using (StreamReader reader = new StreamReader(
                    new FileStream(this.PathToFile, FileMode.Open)))
                {
                    string row = string.Empty;
                    while ((row = reader.ReadLine()) != null)
                    {
                        builder.Append(row);
                        builder.Append(System.Environment.NewLine);
                    }
                }
                OriginalFileContent = builder.ToString();
            }
            catch (FileNotFoundException e) { OriginalFileContent = e.Message; }
            catch (IOException e)           { OriginalFileContent = e.Message; }
            catch (System.Exception e)      { OriginalFileContent = e.Message; }
        }

        public string RunTmpCode(string code)
        {
            using (StreamWriter writer = new StreamWriter(
                new FileStream(PathToTmp, FileMode.Create, FileAccess.Write)))
            {
                writer.WriteLine(code);
            }
            return Classes.SubProcess.RunExternalCode(PathToTmp).ToString();
        }

        public string RunExampleCode()
        {
            StringBuilder builder = new StringBuilder(128);
            try
            {
                return Classes.SubProcess.RunExternalCode(PathToFile).ToString();
            }
            catch (FileNotFoundException e) { builder.Append(e.Message); }
            catch (IOException e)           { builder.Append(e.Message); }
            catch (System.Exception e)      { builder.Append(e.Message); }
            return builder.ToString();
        }
    }
}