﻿using System;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace Aplication.Models
{
    [Serializable()]
    public class LessonModel
    {
        private static string lorem = 
        "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum." + 
        "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."
        ;

        public static readonly string PATH_PREFIX =
            @"C:\Users\Kubis\Desktop\Bakalarska praca\Aplikacia remake\Serializable";

        public const string KEY_TO_SESSION = "lessonModel";

        public string Formated { get; set; }
        public string Original { get; set; }
        public string[] Times { get; set; }
        public string LessonName { get; set; }
        public string VideoPath { get; set; }
        //public LessonModel NextChapter { get; set; }
        public int NextChapter { get; set; }
        public int PageIndex { get; set; }

        public static bool LessonExists(string lessonName, int pageIndex)
        {
            string path = Path.Combine(PATH_PREFIX, lessonName,
                lessonName + pageIndex.ToString() + ".obj");
            return File.Exists(path);
        }

        public static LessonModel ParseFromText(string lessonName, string formated, string original)
        {
            LessonModel result = new LessonModel();
            formated = formated.Replace("&lt;", "<")
                            .Replace("&gt;", ">")
                            .Replace("\t", "&#9;")
                            .Replace(Environment.NewLine, "<br>");

            string[] pauseValues = formated.Split(new string[] { "<br>" }, StringSplitOptions.RemoveEmptyEntries);
            int lastInx = pauseValues.Length - 1;
            string times = pauseValues[lastInx];
            result.Times = times.Split(',');

            result.Formated = string.Join("<br>", pauseValues, 0, lastInx);
            result.LessonName = lessonName;
            result.Original = original;
            return result;
        }

        public static LessonModel LoadByLessonName(string lessonName)
        {
            return LoadByLessonName(lessonName, 0);
        }

        public static LessonModel LoadByLessonName(string lessonName, int pageIndex)
        {
            string path = Path.Combine(PATH_PREFIX, lessonName);          //path to directory
            try
            {
                path = Directory.GetFiles(path)[pageIndex];                   //path to the object
            }
            catch (IndexOutOfRangeException)
            {
                path = Path.Combine(path, lessonName + pageIndex.ToString() + ".obj");
            }
            return Load(path);
        }

        public static LessonModel Load(string path)
        {
            LessonModel content = null;
            try
            {
                BinaryFormatter formatter = new BinaryFormatter();
                using (FileStream stream = new FileStream(path, FileMode.Open))
                {
                    content = formatter.Deserialize(stream) as LessonModel;
                }
            }
            catch (IOException e)
            {
                Console.WriteLine(e.Message);
            }
            return content;
        }

        public static bool SaveByLessonName(LessonModel content, string lessonName)
        {
            string path = Path.Combine(PATH_PREFIX, lessonName); //path to directory

            path = Path.Combine(PATH_PREFIX, lessonName,
                lessonName + content.PageIndex.ToString() + ".obj");     //path to the object
            return Save(content, path);
        }

        public static bool Save(LessonModel content, string path)
        {
            if (content == null)
                return false;
            try
            {
                BinaryFormatter formatter = new BinaryFormatter();
                using (FileStream stream = new FileStream(path, FileMode.Create))
                {
                    formatter.Serialize(stream, content);
                }
            }
            catch (IOException e)
            {
                Console.WriteLine(e.Message);
                return false;
            }
            return true;
        }

        public LessonModel()
        {
            Original = string.Empty;
            Formated = lorem;
            Times = new string[] { "" };
            VideoPath = string.Empty;
            LessonName = string.Empty;
            // NextChapter = null;      //may cause issues when serializing
            NextChapter = -1;
            PageIndex = 0;
        }

        public override string ToString()
        {
            return LessonName.ToString() + " - " + this.PageIndex;
        }
    }
}