var converted = [];

const $e = (elName, cls, parEl) => {
    var e = document.createElement(elName);
    if (cls) e.classList.add(cls);
    if (parEl) parEl.appendChild(e);
    return e;
};

function prepareStreaming() {
    navigator.mediaDevices.getDisplayMedia({
        video: true
    })
        .then(videoStream => {
            navigator.mediaDevices.getUserMedia({
                audio: true
            })
                .then(audioStream => {
                    videoStream.addTrack(
                        audioStream.getAudioTracks()[0]
                    );
                });
            vid.srcObject = videoStream;
        });
}

function stopStreaming() {
    if (vid.srcObject === null || vid.srcObject == null ||
        vid.srcObject === undefined || vid.srcObject == undefined) {
        return;
    }
    vid.srcObject.getTracks().forEach((track) => {
        track.stop();
    });
    vid.srcObject = null;
}

function pauseVideoOnTimes(times) {
    // console.log("times are" + times);
    if (times === undefined)
        times = converted;
    if (times != undefined && times != null)
        if (times.indexOf(vid.currentTime) > -1)
            vid.pause();
}

function convertTimes(listOfTimes) {
    converted.constructor();
    listOfTimes.forEach(val => {
        val = val.split(":");
        seconds = (+val[0]) * 60 * 60 + (+val[1]) * 60 + (+val[2]);
        converted.push(seconds);
    });
}

function parseTimes(list) {
    let findings = [];
    let regexp = /\d\d:\d\d:\d\d/gi;
    list.forEach(elem => {
        let matches = elem.match(regexp);
        if (matches != null && matches != undefined) {
            findings = findings.concat(matches);
        }
    });
    convertTimes(findings);
}

function myReadFile(fileElem) {
    fileElem = fileElem.split("src=")[1].split(' ')[0].trim().replaceAll('\'', '');
    let file_name = fileElem.toString();
    if (file_name.indexOf('.py') > -1)
        file_name = file_name.substring(0, file_name.indexOf('.py'));


    // console.log("file_name = " + file_name);
    let frm = "<iframe src=\'" + file_name;
    frm += ".py\' style=\'width:auto; height: auto; border: none;\'></iframe><br>";
    return [frm, file_name];
}

function preview(text, preview_elem) {
    let all_lines = text.split('\n');
    let codeStart = false;
    let time_vals = [];
    let timesStart = false;
    let elem = "<div style=\'color:orange; font-weight:bold;\'>\n";
    for (let i = 0; i < all_lines.length; i++) {
        let line = all_lines[i];
        line = line.replaceAll("\t", "&#9;");
        if (line.startsWith('```')) {
            codeStart = !codeStart;
            if (codeStart) {
                elem += "\t" +
                    "<pre style=\'width:auto; margin:10px; padding:10px;\'>\n";
            }
            else { elem += "</pre>"; }
        }
        else if (line.startsWith('***'))
            timesStart = !timesStart;

        else if (line.indexOf("file") > -1 && (line.indexOf('<') > -1 || line.indexOf('&lt;') > -1)) {
            let pair = myReadFile(line);
            let text = pair[0];
            elem += text + "\n";
            elem += "<a target='_blank' href=";
            elem += "\'/code/runcode?filename=" + pair[1] + "\'>Try it yourself &gt;&gt;</a>\n<br>";
        }

        else {
            if (timesStart)
                time_vals.push(line);
            else if (!codeStart)
                elem += line + "\n<br>";
            else
                elem += line + "\n";
        }
        // console.log("line = " + line);
    }
    elem += "</div>\n";
    preview_elem.innerHTML = elem;
    parseTimes(time_vals);
}

function replaceTags(text, tagsToChars) {
    if (tagsToChars) {
        text = text.replaceAll("<", "&lt;")
            .replaceAll(">", "&gt;")
            .replaceAll("<br>", "\r\n")
            .replaceAll("&#9;", "\t");
    } else {
        text = text.replaceAll("&lt;", "<")
            .replaceAll("&gt;", ">")
            .replaceAll("\r\n", "<br>")
            .replaceAll("\t", "&#9;");
    }
    return text
}

function separate(elem_from, hidden_elem, preview_elem) {
    preview_elem.innerHTML = "";
    preview(elem_from.value, preview_elem);
    hidden_elem.value = code_div.innerHTML.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    hidden_elem.value += converted;
    elem_from.value = replaceTags(elem_from.value, true);
}