import pygame
import image as i
from pygame.locals import *
import Background as b
nazov_okna = "MAP"
TILESIZE = 100 # velkosť políčka


# snaha o zobrazenie obrazka
class Token:
    def __init__(self,size=4, obrazok = 'character.jpg'):
        self.click = False
        self.rect = Rect(0,0,size*25,size*25)
        self.image = i.Image('character.jpg', size).get_rect()
        #self.image.set_to_round()
        #self.image.set_size(size)


    def update(self, surface):
        if self.click:
            self.rect.center = pygame.mouse.get_pos()
        surface.blit(self.image, self.rect)


class Game:
    def __init__(self):
        pygame.init()#inicializuje pygame
        pygame.display.set_caption(nazov_okna)#nastavuje sa názov okna
        self.clock = pygame.time.Clock()#zaplne clock TODO
        self.surface = pygame.display.set_mode((1000, 800))#nastavuje sa veľkosť okna
        self.BackGround = b.Background('map2.jpg', [0, 0],TILESIZE)#inacialuze background
        self.keep_looping = True
        # pohyb myši na mape
        self.imgPos = pygame.Rect((0, 0), (0, 0))
        self.LeftButton = 0
        self.players = []
        self.players.append(Token(4))
        self.bkgMoving = False
#        self.Player = Token(4)

    def events(self):
        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                self.keep_looping = False# vypne po stalčený x-ka na roku obrazovky
            elif event.type == pygame.KEYDOWN:
                if event.key == pygame.K_ESCAPE:
                    self.keep_looping = False# vypne po stalčený ESCAPE na roku obrazovky

            elif event.type == MOUSEBUTTONDOWN:
                #todo zistit co vsetko sa ma posuvat
                moveBkg = True
                for player in self.players:
                    if player.rect.collidepoint(event.pos):
                        player.click = True
                        print('moving player')
                        moveBkg = False
                if moveBkg:
                    self.bkgMoving = True
                    print('moving bkg')
                    for player in self.players:
                        player.click = True
                        print('moving player')

            elif event.type == MOUSEBUTTONUP:
                self.bkgMoving = False
                for player in self.players:
                    player.click = False

            elif event.type == MOUSEMOTION:
                rel = event.rel
                if self.bkgMoving:
                    self.imgPos.x += rel[0]
                    self.imgPos.y += rel[1]
                for player in self.players:
                    if player.click:
                        player.rect = player.rect.move(rel[0], rel[1])


    def drawGrid(self):
        # vytvorí grid na Backrounde
        height,windth = self.BackGround.image.get_size()
        for x in range(0, height, TILESIZE):
            for y in range(0, windth, TILESIZE):
                rect = pygame.Rect(x, y, TILESIZE, TILESIZE)
                pygame.draw.rect(self.BackGround.image, (255, 255, 255), rect, 1)


    def update(self):
        #self.Player.update()
        pass

    def draw(self):
        pygame.display.update()




    def main(self):
        while self.keep_looping:
            self.surface.fill([230, 223, 204])
            self.events()
            self.surface.blit(self.BackGround.image, self.imgPos)
            # snaha o zobrazenie obrazka
            for player in self.players:
                self.surface.blit(player.image, player.rect)

            self.drawGrid()
            pygame.display.flip()
            pygame.time.delay(30)
            self.update()
            self.draw()



if __name__ == "__main__":
    mygame = Game()
    mygame.main()
