import pygame
import pygame.freetype
from pygame.sprite import Sprite
from pygame.rect import Rect
from enum import Enum
from pygame.sprite import RenderUpdates
import Gamestate
import Map
BLUE = (106, 159, 181)
WHITE = (255, 255, 255)


def create_surface_with_text(text, font_size, text_rgb, bg_rgb):
    # vráti povrch s textom
    font = pygame.freetype.SysFont("Courier", font_size, bold=True)
    surface, _ = font.render(text=text, fgcolor=text_rgb, bgcolor=bg_rgb)
    return surface.convert_alpha()


class UIElement(Sprite):
    # user interface na povrchoch- bottonov

    def __init__(self, center_position, text, font_size, bg_rgb, text_rgb, action=None):
        # či prechádzame myšou
        self.mouse_over = False

        # text pre normálne zobrazenie- bottonov
        default_image = create_surface_with_text(
            text=text, font_size=font_size, text_rgb=text_rgb, bg_rgb=bg_rgb
        )

        # texet pre zobraznie mouse-over - bottonov
        highlighted_image = create_surface_with_text(
            text=text, font_size=font_size * 1.2, text_rgb=text_rgb, bg_rgb=bg_rgb
        )
        self.images = [default_image, highlighted_image]

        # trojuholnik bottonov
        self.rects = [
            default_image.get_rect(center=center_position),
            highlighted_image.get_rect(center=center_position),
        ]

        self.action = action

        super().__init__()

    #logika mouse over
    @property
    def image(self):
        return self.images[1] if self.mouse_over else self.images[0]

    @property
    def rect(self):
        return self.rects[1] if self.mouse_over else self.rects[0]

    def update(self, mouse_pos, mouse_up):
        # updatuje mouse_over premenú a vráti button akciu
        if self.rect.collidepoint(mouse_pos):
            self.mouse_over = True
            if mouse_up:
                return self.action
        else:
            self.mouse_over = False

    def draw(self, surface):
        # vytvorní na ploche pomocou blit
        surface.blit(self.image, self.rect)



def main():
    # inicializuje pygame
    pygame.init()
    # inastavenie velkosti okna a nastavenie Gamestate
    screen = pygame.display.set_mode((800, 600))
    game_state = Gamestate.GameState.TITLE
    # Gamestate - modul hry TODO Json subor

    # Volanie podľa vybraních buttonov
    while True:
        if game_state == Gamestate.GameState.TITLE:
            game_state = title_screen(screen)

        if game_state == Gamestate.GameState.NEWGAMEPLAYER:
            game_state = play_level(screen)

        if game_state == Gamestate.GameState.NEWGAMEDM:
            game_state = play_level(screen)

        if game_state == Gamestate.GameState.QUIT:
            pygame.quit()
            return

# Volanie a vytovrenie menu a buttonov
def title_screen(screen):
    startDM_btn = UIElement(
        center_position=(400, 300),
        font_size=30,
        bg_rgb=BLUE,
        text_rgb=WHITE,
        text="Start as DM",
        action=Gamestate.GameState.NEWGAMEDM,
    )
    startPLAYER_btn = UIElement(
        center_position=(400, 400),
        font_size=30,
        bg_rgb=BLUE,
        text_rgb=WHITE,
        text="Start as Player",
        action=Gamestate.GameState.NEWGAMEPLAYER,
    )
    quit_btn = UIElement(
        center_position=(400, 500),
        font_size=30,
        bg_rgb=BLUE,
        text_rgb=WHITE,
        text="Quit",
        action=Gamestate.GameState.QUIT,
    )

    buttons = RenderUpdates(startDM_btn,startPLAYER_btn, quit_btn)

    return game_loop(screen, buttons)

# funkcia na spustnie hry
def play_level(screen):
    mygame = Map.Game()
    # testujeme či  funguje DMmode
    if (Gamestate.GameState.DMmode == True):
        mygame.BackGround = Gamestate.GameState.Background('map1.jpg', [0, 0])

    mygame.main()




def game_loop(screen, buttons):
    # Loopuje pokila sa eventy nestanu
    while True:
        mouse_up = False
        for event in pygame.event.get():
            if event.type == pygame.MOUSEBUTTONUP and event.button == 1:
                mouse_up = True
        screen.fill(BLUE)

        for button in buttons:
            ui_action = button.update(pygame.mouse.get_pos(), mouse_up)
            if ui_action is not None:
                return ui_action

        buttons.draw(screen)
        pygame.display.flip()





if __name__ == "__main__":
    main()